<?php

if(!ISSET($_POST['submit'])){ 
  // If form has not been submitted yet. 
  // Can be displayed as if(!isset($_POST['submit']))
  displayUploadForm();

  echo "<h3>All images currently in the uploads folder</h3>";
  displayAllImages('uploads/');
  
}else{
//Form has been submitted
//var_dump($_FILES);
// checks to see if a file has actually been submitted  
if(ISSET($_FILES['fileName']['name'])){ 
    //echo "We got this far.";  
      //initializes an empty error array
      $errors= array();

      //if a file exists, get the file information
      $file_name =$_FILES['fileName']['name'];
      $file_size =$_FILES['fileName']['size'];
      $file_tmp =$_FILES['fileName']['tmp_name'];
      $file_type=$_FILES['fileName']['type'];

      //Above line splits all the file name from the file extension and saves the extension on $file_ext
      $file_ext=strtolower(end(explode('.',$_FILES['fileName']['name'])));
     
      //List all the allowed file type extensions
      $extensions= array("jpeg","jpg","png","gif");
      
      //checked if the file extension is allowed and if not, record the error in to the $errors array.
      if(in_array($file_ext,$extensions)=== false){
         $errors[]="extension not allowed, please choose a different file type.";
      }

      //Checks to see if the file size is too large. Comment out if not required
      if($file_size > 2097152){
         $errors[]='File size must be under 2 MB';
      }
      
      //If there the $errors array is empty, upload the file
      if(empty($errors)==true){
         move_uploaded_file($file_tmp,"uploads/".$file_name);
         echo "<h2>Success!</h2>";
	 echo "<p>You can now reference and access this file at: uploads/" . $file_name . "</p>";
     echo "<img class=\"profilePic\" src=\"uploads/" . $file_name . "\">";  
    }else{
          echo "<h2>There was an error.</h2>";
          foreach($errors as $val){
            echo "<p>" . $val . "</p>";
          }
          displayUploadForm();
      }
   }else{
      echo "<h2>No file uploaded</h2>";
      displayUploadForm();
   }	
}

function displayAllImages($folder)
{
    $folder = "uploads/";
    $images = glob($folder . '*.{jpg,jpeg,png,gif}', GLOB_BRACE);
    foreach ($images as $image) {
        echo "<img class=\"profilePic\" src=\"" . $image . "\">";
    }
}
function displayUploadForm(){ 
    ?>
  <form method="post" action="index.php?link=image-upload"  enctype="multipart/form-data">
    <fieldset><legend>File upload facility</legend>
      <label for="fileName">File</label><input type="file" id="fileName" name="fileName">
      <button type="submit" name="submit" value="Upload File">Upload file</button>
    </fieldset>
  </form>
<? 
} 
?>
