<?php session_start();
require_once("includes.php");

if(ISSET($_GET['link'])){
    $pageLink = filter_var(trim($_GET['link']), FILTER_SANITIZE_FULL_SPECIAL_CHARS);
}else{
   $pageLink = 'Home'; 
}
$query = "SELECT * FROM content WHERE link = ?";
connectDB();
$stmt = mysqli_prepare($_SESSION['db'],$query);
mysqli_stmt_bind_param($stmt,'s',$pageLink);
// s is for string
// d is for double
// i is for integer
// b is for blob

mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

closeDB();
if(mysqli_num_rows($result)>0){
    $row = mysqli_fetch_assoc($result);
    if(!isset($_SESSION['msg'])){
        $_SESSION['msg'] =null;
    }
    if(!isset($_SESSION['priv'])){
        //If a user does not have a privelge level set, then set it to 0
        $_SESSION['priv'] = 0;
    }
    if($row['priv'] > 0){
        //If the page priv is greater than 0 -check the user's priv level
        // to see if they have adequate access
        if($row['priv'] > $_SESSION['priv']){
            $_SESSION['msg'] = 'You do not have permission to view this page.';
            $_SESSION['msg_type'] = 'error';
            header("Location:index.php?lin=404");
            exit();
        }
    }
}else{
    $_SESSION['msg'] = 'Page not found';
    $_SESSION['msg_type'] = 'caution';
    header("Location: index.php?link=404");
    exit();

}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!--<link rel="stylesheet" href="css/main.css">-->
    <title><?=$row['title']?></title>
    <link rel="stylesheet" href="css/style.css">
    <script src="https://code.jquery.com/jquery-3.7.1.min.js" 
    integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" 
    crossorigin="anonymous"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.2/font/bootstrap-icons.min.css">
</head>
<body>

<? nav($row['link']); ?>
<h1><?=$row['h1']?></h1>
<?
if (isset($_SESSION['msg'])) {
    msg();
}
?>
<p><?=$row['content']?></p>
<!-- <p>Password hash: -->
    <?php
   // echo password_hash("Meatpie1", PASSWORD_DEFAULT) . "<br>";
    ?>

<?php
if($row['includes'] !=""){
    include($row['includes']);
}
if(isset($_SESSION['auth'])){
    //user has logged in
    if($_SESSION['priv']>= $row['priv'] && $row['searchable'] == 'y'){
        //user can edit this page
        //less secure option (but still works)
        //echo "<p><a href=\"index.php?link=page-management&pageLink=" . $row['link'] . "\">Edit this page</a></p>";
        //more secure option | best practice
        ?>
        <form action="index.php?link=page-management" method="post" id="editForm">
            <input type="hidden" name="id" value="<?=$row['id']?>">
            <button type="submit" value="displayPage" name="submit">Edit this page</button>
    </form>
    <?
    }
}
?>
</body>
</html>